/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.fishing;

import com.lothrazar.cyclic.ModCyclic;
import com.lothrazar.cyclic.block.TileBlockEntityCyclic;
import com.lothrazar.cyclic.block.fishing.ContainerFisher;
import com.lothrazar.cyclic.data.DataTags;
import com.lothrazar.cyclic.registry.TileRegistry;
import com.lothrazar.cyclic.util.ItemStackUtil;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.LootTables;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class TileFisher
extends TileBlockEntityCyclic
implements MenuProvider {
    private static final int RADIUS = 12;
    private static final double CHANCE = 0.1;
    ItemStackHandler inventory = new ItemStackHandler(1){

        public boolean isItemValid(int slot, ItemStack stack) {
            return stack.m_204117_(DataTags.FISHING_RODS);
        }
    };
    LazyOptional<IItemHandler> inventoryCap = LazyOptional.of(() -> this.inventory);

    public TileFisher(BlockPos pos, BlockState state) {
        super((BlockEntityType)TileRegistry.FISHER.get(), pos, state);
        this.needsRedstone = 0;
    }

    public static void serverTick(Level level, BlockPos blockPos, BlockState blockState, TileFisher e) {
        e.tick();
    }

    public static <E extends BlockEntity> void clientTick(Level level, BlockPos blockPos, BlockState blockState, TileFisher e) {
        e.tick();
    }

    public Component m_5446_() {
        return new TextComponent(this.m_58903_().getRegistryName().m_135815_());
    }

    public AbstractContainerMenu m_7208_(int i, Inventory playerInventory, Player playerEntity) {
        return new ContainerFisher(i, this.f_58857_, this.f_58858_, playerInventory, playerEntity);
    }

    public void invalidateCaps() {
        this.inventoryCap.invalidate();
        super.invalidateCaps();
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.inventoryCap.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        this.inventory.deserializeNBT(tag.m_128469_("inv"));
        super.m_142466_(tag);
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        tag.m_128365_("inv", (Tag)this.inventory.serializeNBT());
        super.m_183515_(tag);
    }

    public void tick() {
        int z;
        int y;
        int x;
        BlockPos center;
        if (this.requiresRedstone() && !this.isPowered()) {
            return;
        }
        ItemStack stack = this.inventory.getStackInSlot(0);
        if (stack.m_204117_(DataTags.FISHING_RODS) && TileFisher.isWater(this.f_58857_, center = new BlockPos(x = this.f_58858_.m_123341_() + this.f_58857_.f_46441_.nextInt(24) - 12, y = this.f_58858_.m_123342_(), z = this.f_58858_.m_123343_() + this.f_58857_.f_46441_.nextInt(24) - 12))) {
            try {
                this.doFishing(stack, center);
            }
            catch (Exception e) {
                ModCyclic.LOGGER.error("Fishing Block: Loot table failed", e);
            }
        }
    }

    public static boolean isWater(Level level, BlockPos center) {
        return level.m_8055_(center).m_60734_() == Blocks.f_49990_;
    }

    private void doFishing(ItemStack fishingRod, BlockPos center) {
        Level world = this.m_58904_();
        Random rand = world.f_46441_;
        if (rand.nextDouble() < 0.1 && world instanceof ServerLevel) {
            LootTables manager = world.m_142572_().m_129898_();
            if (manager == null) {
                return;
            }
            LootTable table = manager.m_79217_(BuiltInLootTables.f_78720_);
            if (table == null) {
                return;
            }
            int luck = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44953_, (ItemStack)fishingRod) + 1;
            Vec3 fffffffffff = new Vec3((double)center.m_123341_(), (double)center.m_123342_(), (double)center.m_123343_());
            LootContext lootContext = new LootContext.Builder((ServerLevel)world).m_78963_((float)luck).m_78977_(rand).m_78972_(LootContextParams.f_81460_, (Object)fffffffffff).m_78972_(LootContextParams.f_81463_, (Object)fishingRod).m_78975_(LootContextParamSets.f_81414_);
            List lootDrops = table.m_79129_(lootContext);
            if (lootDrops != null && lootDrops.size() > 0) {
                ItemStackUtil.damageItem(null, fishingRod);
                ItemStackUtil.drop(world, center, lootDrops);
            }
        }
    }

    @Override
    public void setField(int field, int value) {
        switch (Fields.values()[field]) {
            case REDSTONE: {
                this.needsRedstone = value % 2;
            }
        }
    }

    @Override
    public int getField(int field) {
        switch (Fields.values()[field]) {
            case REDSTONE: {
                return this.needsRedstone;
            }
        }
        return 0;
    }

    static enum Fields {
        REDSTONE;

    }
}

